proc tabulate missing noseps data = ghpb08;
TITLE 'Table B3.  Distribution of Participants';
TITLE2 'by type of insurance, plan, and number of health insurance contracts, 2008';
TITLE3 '(numbers in thousands)';
CLASS contract_num_HEALTH INS3 ENT2 filingsize;
FORMAT INS3 INS3F.;
VAR TPART;                                                                                                                                                                                                                                                                                                                                                                
KEYLABEL ALL='Total';                                                                                                                                                                                                                                                                                                                                                                                 
TABLE   all='Total Plans' filingsize=' ',                                                                                                                                                                      
		(ALL contract_num_HEALTH=' ')*tpart=' '*sum=' '*f=k12f.,                                                                                                                                                                                       
		(ALL INS3=' ')*(ALL ENT2=' ')/MISSTEXT='-';                                                                                                                              
RUN;  
